/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Collections;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.UmlRt;
using Borland.Eco.Services;
using Borland.Eco.Handles;

namespace Borland.Eco.Web
{
	/// <summary>
	/// Summary description for Class.
	/// </summary>
	public class ControlBuilder
	{
		public static Label MakeNewLabel(Control host, IFeature sf)
		{
			if (sf == null)
				throw new ArgumentNullException("sf");
			return MakeNewLabel(host, sf.Name);
		}

		public static Label MakeNewLabel(Control host, string text)
		{
			if (host == null)
				throw new ArgumentNullException("host");
			Label result = new Label();
			result.Text = text;
			host.Controls.Add(result);
			return result;
		}

		public static TextBox MakeNewTextBox(string name, Control host)
		{
			if (host == null)
				throw new ArgumentNullException("host");
			TextBox result = new TextBox();
			result.ID = name;
			host.Controls.Add(result);
			return result;
		}

		public static LinkButton MakeNewLinkButton(string name, Control host)
		{
			if (host == null)
				throw new ArgumentNullException("host");
			LinkButton result = new LinkButton();
			result.ID = name;
			host.Controls.Add(result);
			return result;
		}

		public static HyperLink MakeNewHyperLink(string name, Control host)
		{
			//if (host == null)
			//	throw new ArgumentNullException("host");
			HyperLink result = new HyperLink();
			result.ID = name;
			if (host != null)
				host.Controls.Add(result);
			return result;
		}

		public static CheckBox MakeNewCheckBox(string name, Control host)
		{
			CheckBox result = MakeNewCheckBox(name, host, "");
			return result;
		}

		public static CheckBox MakeNewCheckBox(string name, Control host, IFeature sf)
		{
			if (sf == null)
				throw new ArgumentNullException("sf");
			CheckBox result = MakeNewCheckBox(name, host, sf.Name);
			return result;
		}
		public static CheckBox MakeNewCheckBox(string name, Control host, string text)
		{
			if (host == null)
				throw new ArgumentNullException("host");
			CheckBox result = new CheckBox();
			result.ID = name;
			result.Text = text;
			host.Controls.Add(result);
			result.Visible = true;
			return result;
		}

		public static DropDownList MakeDropDownList(string name, Control host)
		{
			if (host == null)
				throw new ArgumentNullException("host");
			DropDownList result = new DropDownList();
			result.ID = name;
			host.Controls.Add(result);
			return result;
		}

		public static ListBox MakeListBox(string name, Control host)
		{
			if (host == null)
				throw new ArgumentNullException("host");
			ListBox result = new ListBox();
			result.ID = name;
			host.Controls.Add(result);
			return result;
		}

		public static Table MakeNewTable(string name, Control host)
		{
			if (host == null)
				throw new ArgumentNullException("host");
			Table result = new Table();
			result.ID = name;
			host.Controls.Add(result);
			return result;
		}

		public static TableRow MakeNewTableRow(string name, Table table)
		{
			if (table == null)
				throw new ArgumentNullException("table");
			TableRow result = new TableRow();
			result.ID = name;
			table.Rows.Add(result);
			return result;
		}

		public static TableCell MakeNewTableCell(string name, TableRow tableRow)
		{
			if (tableRow == null)
				throw new ArgumentNullException("tableRow");
			TableCell result = new TableCell();
			result.ID = name;
			result.VerticalAlign = VerticalAlign.Top;
			result.HorizontalAlign = HorizontalAlign.Left;
			tableRow.Cells.Add(result);
			return result;
		}

		public static void MakeNewSpace(Control host)
		{
			MakeNewBoldText(host, " "); // do not localize
		}

		public static void MakeNewNbsp(Control host)
		{
			MakeNewBoldText(host, "&nbsp;"); // do not localize
		}
		
		public static void MakeNewBoldText(Control host, string text)
		{
			if (host == null)
				throw new ArgumentNullException("host");
			HtmlGenericControl html = new HtmlGenericControl("b");
			html.InnerText = text;
			host.Controls.Add(html);
		}

		///<summary>
		///Builds a control for a member. The actual control depends of the type of the member.
		///</summary>
		///<param name="controlName">The name you want to give your control, uniquely identifying it among the controls on the page.</param>
		///<param name="hostControl">The control used as container for created control.</param>
		///<param name="handle">The handle is used for data binding.</param>
		///<param name="memberName">Binding name of member.</param>
		///<param name="classifier">The type of the member.</param>
		///<param name="allowNull">Indicates if the member allows null values.</param>
		///<param name="readOnly">Indicates if the member is readonly.</param>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="hostControl"/> is null.</exception>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="handle"/> is null.</exception>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="classifier"/> is null.</exception>
		public static Control BuildControl(string controlName, Control hostControl, ElementHandle handle, string memberName, IClassifier classifier, bool allowNull, bool readOnly)
		{
			if (hostControl == null) throw new ArgumentNullException("hostControl");  // do not localize
			if (handle == null) throw new ArgumentNullException("handle"); // do not localize
			if (classifier == null) throw new ArgumentNullException("classifier"); // do not localize
			if (classifier.ClassifierType == ClassifierType.Class)
			{
				TextBox textBox = MakeNewTextBox(controlName, hostControl);
				ExpressionHandle asStringHandle = new ExpressionHandle();
				asStringHandle.RootHandle = handle;
				asStringHandle.Expression = handle.Columns[memberName].Expression + ".asString"; // do not localize

				//textBox.DataBindings.Add(new System.Windows.Forms.Binding("Text", asStringHandle, "self")); // do not localize
				return textBox;

			}
			//Handle boolean values
			if (classifier.ObjectType == typeof(bool))
			{
				CheckBox checkBox = MakeNewCheckBox(controlName, hostControl);
				//checkBox.DataBindings.Add(new System.Windows.Forms.Binding("Checked", handle, memberName)); // do not localize
				checkBox.Enabled = !readOnly;
				return checkBox;
			}
			// Handle enumerations
			if (classifier.ClassifierType == ClassifierType.Enumeration)
			{
				DropDownList dropDownList = MakeDropDownList(controlName, hostControl);
				dropDownList.DataSource = Enum.GetValues(classifier.ObjectType);
				//dropDownList.DataBindings.Add(new System.Windows.Forms.Binding("SelectedItem", handle, memberName)); // do not localize
				dropDownList.Enabled = !readOnly;
				return dropDownList;
			}
			// last resort - handles everything not handled above
			TextBox tbx = MakeNewTextBox(controlName, hostControl);
			//tbx.DataBindings.Add(new System.Windows.Forms.Binding("Text", handle, memberName)); // do not localize
			tbx.ReadOnly = readOnly;
			return tbx;
		}

	}
}
